unit Dispatch03;

interface

uses
  //  
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, ComCtrls,
  //  
  CommonDEF03, CommonDAT03, CommonSRV03, ConsoleMAIN;

// ==========================================================================
//      
// ==========================================================================
// ( !)
type TRequest = record
  RqCmd   : string;      //   
  RqPrm   : string;      //    
  Replay  : string;      //    
  //      GET
  Buffer  : pointer;     //    nil
  BufSize : integer;     //    
end;

// --------------------------------------------------------------------------
//      
function SetRequest(RqAppIndx : integer;
                    RqCmdInd  : integer;
               var RqRequest  : TRequest) : boolean;


//    
procedure ShowResult(RqAppIndx : integer;
                     RqRequest : TRequest;
                     RqReport  : TMemo);


// =========================================================================
// =========================================================================
implementation
// =========================================================================
// =========================================================================

// =========================================================================
//       , 
//     .    
//       .
// =========================================================================
// --------------------------------------------------------------------------
// 08.01.2018
// (    !)
//      
function SetRequest(RqAppIndx : integer;
                    RqCmdInd  : integer;
               var RqRequest  : TRequest) : boolean;
var wBufItem : integer;
    
begin
  Result := False;
  if RqAppIndx < 0 then Exit;
  //      
  FillChar(RqRequest, SizeOf(RqRequest), #0);
  //      
  with RqRequest do
  begin
     //***
     Buffer   := Addr(DataBuffer);
     wBufItem := Length(AllPtScopeArr[RqAppIndx].ArrSOBJ);
     RqRequest.BufSize := wBufItem * SizeOF(TBufferItem);

     case RqCmdInd of
     0 : begin
           RqCmd   := 'GET';
           RqPrm   := '00';
           Result  := True;
         end;
     1 : begin
           RqCmd   := 'GET';
           RqPrm   := '01';
           Result  := True;
         end;
     2 : begin
           RqCmd   := 'GET';
           RqPrm   := '02';
           Result  := True;
         end;
     3 : begin
           RqCmd   := 'GET';
           RqPrm   := '03';
           Result  := True;
         end;
     4 : begin
           RqCmd   := 'GET';
           RqPrm   := '04';
           Result  := True;
         end;
     5 : begin
           RqCmd   := 'GET';
           RqPrm   := '05';
           Result  := True;
         end;  
     6 : begin
           RqCmd   := 'GET';
           RqPrm   := '06';
           Result  := True;
         end;
     end;
  end;
end;
// =========================================================================
//           
//      .
//   (TMemo)      ( ).
// =========================================================================
// --------------------------------------------------------------------------
//      
//     
procedure RequestReport(RqAppIndx : integer; RqReport : TMemo);
var Ind     : integer;

begin
   RqReport.Clear;
   if RqAppIndx < 0 then Exit;
   with RqReport.Lines
   do begin
      //***
      for Ind := 0 to AllPtScopeArr[RqAppIndx].MaxIndx
      do begin
         Add(FloatToStr(DataBuffer.BufArr[Ind].Value));
      end;
      // -------------------------
      //   ,  
      //      .
      ConsoleMAIN.ConsoleForm.ShowSensors;
   end;
end;

// =========================================================================
//         
// =========================================================================
// --------------------------------------------------------------------------
// 08.01.2018
//    
procedure ShowResult(RqAppIndx : integer;
                     RqRequest : TRequest;
                     RqReport  : TMemo);
begin
   if RqAppIndx < 0 then Exit;
   //--------------------
   //  'GET'
   if (UpperCase(RqRequest.RqCmd) = 'GET')
   then begin
      //   
      RequestReport(RqAppIndx, RqReport);
   end;
end;

// =========================================================================
//  
// =========================================================================

end.
